function [mat1,mat2,mat3,mat4]=acqmode2d(mat1,mat2,alt1,neg1,alt2,neg2)
% *** treat a dimention according to the acq mode ***
% Y. Matsuki, December, 2014
% usage:
% acqmode(mat1,mat2,mat3,mat4,alt1,neg1,alt2,neg2)
% =====================================

nt1=size(mat1,2);
nt2=size(mat1,1);

% t2 is complex
% sign alternation
if alt2
    p=1;
    signalt=zeros(nt2,nt1);
    for n=1:2:nt2*2
        signalt(p,:)=sin(n*(pi/2));
        p=p+1;
    end
    mat1=mat1.*signalt;
    mat2=mat2.*signalt;
end

% imaginary negation
if neg2
    p=1;
    signalt=zeros(nt2,nt1);
    for n=1:nt2
        signalt(p,:)=-1;
        p=p+1;
    end
    mat1=complex(real(mat1),imag(mat1).*signalt);
    mat2=complex(real(mat2),imag(mat2).*signalt);
end




% t2 is complex
[mat11,mat22]=rrcplx(mat1,mat2);
% t1 is complex now

% sign alternation
if alt1
    p=1;
    signalt=zeros(nt2,nt1);
    for n=1:2:nt1*2
        signalt(:,p)=sin(n*(pi/2));
        p=p+1;
    end
    mat11=mat11.*signalt;
    mat22=mat22.*signalt;
end

% imaginary negation
if neg1
    p=1;
    signalt=zeros(nt2,nt1);
    for n=1:nt1
        signalt(:,p)=-1;
        p=p+1;
    end
    mat11=complex(real(mat11),imag(mat11).*signalt);
    mat22=complex(real(mat22),imag(mat22).*signalt);
end

% t1 is complex now
        [mat1,mat2]=rrcplx(mat11,mat22);
% t2 is complex now

        
        
        