function [sigf1 sigf2 verptsmod horptsmod intensity temp]=brightPeak_v3(inmat,...
    postable,wnd,refn,...
    sw1,sw2,nc,nr,f1,f2,cent1,cent2)
% *** convert ppm reading to point unit ***
% Y. Matsuki, March, 2009
% usage:
% [out]=ppm2pts(in,sw,np,cent,freq,dir)
% =====================================
% sw1: vertical sw, in Hz
% sw2: horizontal sw, in Hz
% nr: no of rows
% nc: no of columns
% cent1: carrier in vertical axis, in ppm
% cent2: carrier in horizontal axis, in ppm

% v2: modified brightPeak.m to include peakInt.m.
% wnd: intensity summation is done at peak-top+-wnd pts.
% refn: =1 for refine peak position. =0 otherwise.

% v3: for regular data t1/t2, rather than t1/F2.

%% convert ppm to pts.

%% make scale for vertical axis, 1H
del2=sw2/(nr-1);
% FFT algorithm gives FTed data
% [0 -> most positive - half delta;most negative - half delta -> a half delta]

% this stands on a stance to think that center frequency is at 513th point.
% rather than at in-between 512 and 513th points for 1K data for eg.
% (aug1010, ym)
% xp2= sw2/2-del2/2 :-del2: 0;
% xm2=-sw2/2-del2/2 :del2 : -1*del2;
xp2=     0        :del2: sw2/2-del2/2;
xm2=-sw2/2-del2/2 :del2: -1*del2;

xmp2=[xp2 xm2];
xmp2p=(xmp2/f2)+cent2;

%% make scale for horizontal axis, 15N
% feb1109, wed.
% see scrabble note, feb1109, thu
del1=sw1/(nc-1);
% FFT algorithm gives FTed data
% [0 -> most positive - half delta;most negative - half delta -> a half delta]

% this stands on a stance to think that center frequency is at 513th point.
% rather than at in-between 512 and 513th points for 1K data for eg.
% (aug1010, ym)
xp1=     0        :del1: sw1/2-del1/2;
xm1=-sw1/2-del1/2 :del1: -1*del1;
% xp1=    del1/2	:del1: sw1/2;
% xm1=-sw1/2      :del1: -1*del1/2;
% xp1=    0           :del1: sw1/2+del1/2;
% xm1=-sw1/2-del1/2   :del1: -1*del1;

xmp1=[xp1 xm1];
xmp1p=(xmp1/f1)+cent1;

%% vertical axis=F2, 1H
npk=length(postable(:,2));
verppm=postable(:,2);
verpts=zeros(npk,1);
% size(verpts)
for p=1:npk
    for q=1:nr-1
        if ((verppm(p)>=xmp2p(q)) && (verppm(p)<xmp2p(q+1)))
            if abs(xmp2p(q+1)-verppm(p)) < abs(del2/2)
                verpts(p)=q+1;
            else
                verpts(p)=q;
            end
        elseif verppm(p)>=xmp2p(nr) && verppm(p)<=cent2
            if abs(verppm(p)-xmp2p(nr)) < abs(del2/2)
                verpts(p)=nr;
            else
                verpts(p)=1;
            end
        elseif verppm(p)>xmp2p(nr/2)
%         elseif horppm(p)>xmp1p((nc/2)+1)
            disp('ERROR,ppm too big, ver');
        elseif verppm(p)<xmp2p(nr/2+1)
%         elseif horppm(p)<xmp1p(nc/2+2)
            disp('ERROR,ppm too small, ver');
        end
    end
end
% for p=1:npk
%     for q=1:nr-1
%         if(verppm(p)>=cent2)
%             if ((verppm(p)<=xmp2p(q)) && (verppm(p)>xmp2p(q+1)))
%                 if abs(xmp2p(q)-verppm(p)) < abs(del2/2)
%                     verpts(p)=q;
%                 else
%                     verpts(p)=q+1;
%                 end
%             elseif verppm(p)>=xmp2p(1)
%                 disp('ERROR,ppm too big, verr');
%             end
%         else
%             if ((verppm(p)>=xmp2p(q)) && (verppm(p)<xmp2p(q+1)))
%                 if abs(xmp2p(q+1)-verppm(p)) < abs(del2/2)
%                     verpts(p)=q+1;
%                 else
%                     verpts(p)=q;
%                 end
%             elseif verppm(p)>=xmp2p(nr) && verppm(p)<cent2
%                 if abs(verppm(p)-xmp2p(nr)) < abs(del2/2)
%                     verpts(p)=nr;
%                 else
%                     verpts(p)=nr/2;
%                 end
%             elseif verppm(p)>xmp2p(1)
%                 disp('ERROR,ppm too big, ver');
%             elseif verppm(p)<xmp2p(nr/2+1)
%                 disp('ERROR,ppm too small, ver');
%             end
%         end
%     end
% end

% lw_ver=(ceil(postable(:,5)/del2));
% % lw_ver=2;
% sigf2=[verpts-lw_ver verpts+lw_ver];

% temporarily!!!!
% verpts=verpts+1;

%% horizontal axis, 15N
horppm=postable(:,1);
horpts=zeros(npk,1);

for p=1:npk
    for q=1:nc-1
        if ((horppm(p)>=xmp1p(q)) && (horppm(p)<xmp1p(q+1)))
            if abs(xmp1p(q+1)-horppm(p)) < abs(del1/2)
                horpts(p)=q+1;
            else
                horpts(p)=q;
            end
        elseif horppm(p)>=xmp1p(nc) && horppm(p)<=cent1
            if abs(horppm(p)-xmp1p(nc)) < abs(del1/2)
                horpts(p)=nc;
            else
                horpts(p)=1;
            end
        elseif horppm(p)>xmp1p(nc/2)
%         elseif horppm(p)>xmp1p((nc/2)+1)
            disp('ERROR,ppm too big, hor');
        elseif horppm(p)<xmp1p(nc/2+1)
%         elseif horppm(p)<xmp1p(nc/2+2)
            disp('ERROR,ppm too small, hor');
        end
    end
end
% lw_hor=ceil(postable(:,4)/del1);

% % arbitrary!!!!
% lw_hor=lw_hor+2;
% 
% % lw_hor=2;
% sigf1=[horpts-lw_hor horpts+lw_hor];
% % horpts=horpts-2;


%% refine peak position.

% temp1=peakInt(inmat,verpts,horpts,wnd);
temp1=peakInt(inmat,verpts,horpts,wnd,refn); % refine is on w/ refn=1
verptsmod=temp1(:,1);
horptsmod=temp1(:,2);
intensity=temp1(:,3);

temp=verptsmod;

%% make sigfx
lw_ver=(ceil(postable(:,5)/del2))+1;
    sigf2=[verptsmod-lw_ver verptsmod+lw_ver];
lw_hor=ceil(postable(:,4)/del1)+1;

    sigf1=[horptsmod-lw_hor horptsmod+lw_hor];

%% trim the sigfx table.
cnt=1;
for m=1:npk
    if sigf1(m,1)<1
        pts=1-sigf1(m,1); % sigf2(m,1) is 0 or negative.
        sigf1(m,1)=1;
        sigf1(npk+cnt,1)=nc-pts+1;
        sigf1(npk+cnt,2)=nc;
        sigf2(npk+cnt,1)=sigf2(m,1);
        sigf2(npk+cnt,2)=sigf2(m,2);
        cnt=cnt+1;
    elseif sigf1(m,2)>nc
        pts=sigf1(m,2)-nc; % sigf2(m,2) is larger than nc.
        sigf1(m,2)=nc;
        sigf1(npk+cnt,1)=1;
        sigf1(npk+cnt,2)=pts;
        sigf2(npk+cnt,1)=sigf2(m,1);
        sigf2(npk+cnt,2)=sigf2(m,2);
        cnt=cnt+1;
    end
end

cnt=1;
for m=1:npk
    if sigf2(m,1)<1
        pts=1-sigf2(m,1); % sigf2(m,1) is 0 or negative.
        sigf2(m,1)=1;
        sigf2(npk+cnt,1)=nr-pts+1;
        sigf2(npk+cnt,2)=nr;
        sigf1(npk+cnt,1)=sigf1(m,1);
        sigf1(npk+cnt,2)=sigf1(m,2);
        cnt=cnt+1;
    elseif sigf2(m,2)>nr
        pts=sigf2(m,2)-nr; % sigf2(m,2) is larger than nc.
        sigf2(m,2)=nc;
        sigf2(npk+cnt,1)=1;
        sigf2(npk+cnt,2)=pts;
        sigf1(npk+cnt,1)=sigf1(m,1);
        sigf1(npk+cnt,2)=sigf1(m,2);
        cnt=cnt+1;
    end
    
    if sigf2(m,1)<nr/2 && sigf2(m,2)>nr/2
%         pts=sigf2(m,1)-nr/2; % sigf2(m,1) is 0 or negative.
        pts=sigf2(m,2)-nr/2; % sigf2(m,1) is 0 or negative.
        sigf2(m,2)=nr/2;
        sigf2(npk+cnt,1)=nr-pts+1;
        sigf2(npk+cnt,2)=nr;
        sigf1(npk+cnt,1)=sigf1(m,1);
        sigf1(npk+cnt,2)=sigf1(m,2);
        cnt=cnt+1;
    elseif sigf2(m,2)>nr
        pts=sigf2(m,2)-nr; % sigf2(m,2) is larger than nc.
        sigf2(m,2)=nr;
        sigf2(npk+cnt,1)=nr/2-pts+1;
        sigf2(npk+cnt,2)=nr/2;
        sigf1(npk+cnt,1)=sigf1(m,1);
        sigf1(npk+cnt,2)=sigf1(m,2);
        cnt=cnt+1;
    end
end

