function omat=mphasec(imat,sw,ph,dim)
% *** Column-wise matrix phasing ***
% Y. Matsuki, December, 2007
% usage:
% omat=mphasec(imat,sw,ph,dim)
% ========================================================
% use phases found in nmrPipe
% clm: rows=[start column#,end column#]
% p1 is phase across sw: +-p1/2 at +-sw/2
% pivot is at center
% sw is full spectral width in Hz
% ph: [p0 p1] in degree
% dim: refers to MATLAB dim to phase.

% tic
nt2=length(imat(:,1));
nt1=length(imat(1,:));

phasem=zeros(nt2,nt1);

if dim==2
%     % include changes done in mplp and mplp2d. feb0608.
%     xm=-sw/2:sw/nt1:-sw/nt1;
%     xp=0:sw/nt1:(sw/2)-(sw/nt1);

% below is compatible with nmrPipe phase
% see feb0509, scrubble note.
%     pivt=ph(3);
    pivt=1;
    d=sw/(nt1-1);
    xp=d*((nt1/2)-pivt):-1*d:d*(1-pivt);
    xm=d*(nt1-pivt):-1*d:d*((nt1/2)+1-pivt);
    xmp=[xp xm];
    for p=1:nt1
        arg=ph(1)*pi/180 + ((ph(2)*pi/180) / sw ) *xmp(p);
        phasem(:,p)=cos(arg)+1i*sin(arg);
    end
elseif dim==1
%     pivt=ph(3);
    pivt=1;
    d=sw/(nt2-1);
    xp=d*((nt2/2)-pivt):-1*d:d*(1-pivt);
    xm=d*(nt2-pivt):-1*d:d*((nt2/2)+1-pivt);
    xmp=[xp xm];
    for p=1:nt2
        arg=ph(1)*pi/180 + ((ph(2)*pi/180) / sw ) .*xmp(p);
        phasem(p,:)=cos(arg)+1i*sin(arg);
    end
else
    disp('ERROR');
end

omat=phasem.*imat;
% toc
