function mplp2d(imat,sw1,sw2,ppm1,ppm2,f1,f2,v)
% *** matrix contour plot with ppm axis ***
% Y. Matsuki, December, 2007

% modified on feb0922, meshgrid is placed before the contour command.
% this became necessary since mathworks has changed specification of the
% countour command.

% usage:
% mplp2d(imat,sw1,sw2,ppm1,ppm2,f1,f2,v)
% =====================================
% v=number of contours or [contour lines vector]
% specify sw1=spectral width in Hz for vertical axis
% specify sw2=spectral width in Hz for horizontal axis
% specify ppm at the center of axis
% specify f spectrometer freq in MHz

nr=length(imat(:,1));
nc=length(imat(1,:));

% FFT algorithm gives FTed data
% [0 -> most positive - one pts,most negative -> 0 - one pts]
xm1=-sw1/2:sw1/nr:-sw1/nr;
xp1=0:sw1/nr:(sw1/2)-(sw1/nr);
xmp1=[xp1 xm1];
xmp1p=(xmp1/f1)+ppm1;

% xm2=0:-(sw2/2)/((nc/2)-1):-sw2/2;
% xp2=sw2/2:-(sw2/2)/((nc/2)-1):0;
% xmp2=[xm2 xp2];
% xmp2p=-(xmp2/f2)+ppm2;
xm2=-sw2/2:sw2/nc:-sw2/nc;
xp2=0:sw2/nc:(sw2/2)-(sw2/nc);
xmp2=[xp2 xm2];
xmp2p=(xmp2/f2)+ppm2;

% in comparison to scale in nmrPipe,
% no need to shift matrix
% imats=circshift(imat,[-1,-1]);

% contour(xmp2p,xmp1p,imat,v), feb0922
[X,Y]=meshgrid(xmp2p,xmp1p);
contour(X,Y,imat,v)

set(gca,'XDir','reverse')
% set(gca,'YDir','reverse')
