% function outm=rplc(orgm,cycm,timetab,tailc)
function outm=rplc(orgm,cycm,timetab,tailc,sigf2)
% *** Replace columns of 2D matrices ***
% Y. Matsuki, December, 2007
% usage:
% outm=rplc(orgm,cycm,timetab,tailc,sigf2)
% ========================================================
% timetab: vector specifying ACQUIRED time points
% orgm: original matrix with removed time points
% cycm: matrix during the SIFT cycle, 
% from which missing points in orgm are replaced.
% tailc: tail constraint to zero, feb0208.
% sigf2: signal region in NMR F2

% tic
nb=length(timetab);
nbf2=length(sigf2(:,1));

outm=cycm;

for q=1:nbf2
    for m=1:(nb-tailc)
%         outm(:,timetab(m))=orgm(:,timetab(m));    
        outm(sigf2(q,1):sigf2(q,2),timetab(m))=...
        orgm(sigf2(q,1):sigf2(q,2),timetab(m));    
    end
end
