function binout2dfreq(mat,n1,n2,f1,f2,sw1,sw2,o1,o2,a1,a2,outname,pathin)
% *** binary output 2D spectrum to sparky format *** 
% Y. Matsuki, July, 2008
% usage:
% binout(mat,n1,n2,f1,f2,sw1,sw2,o1,o2,a1,a2,outname)
% ========================================================
% o1: lowest field value in ppm
% a1: axis label

% feb1909
% identical to binout.m, filename consistency purpose.

% 128,1024
% 59.882,590.967
% 4000,8012.8
% 150.30,11.58
%15N,1H

% feb2709, path is also arguement now.
% path='/Applications/Sparky.app/Contents/Resources/bin/matrix2ucsf';
path=pathin;
arg1=[' -n1 ',num2str(n1),' -n2 ',num2str(n2)];
arg2=[' -f1 ',num2str(f1),' -f2 ',num2str(f2)];
arg3=[' -sw1 ',num2str(sw1),' -sw2 ',num2str(sw2)];
arg4=[' -o1 ',num2str(o1),' -o2 ',num2str(o2)];
arg5=[' -a1 ',a1,' -a2 ',a2];
io=[outname '.ucsf ' 'test1.mat'];
command=[path,arg1,arg2,arg3,arg4,arg5,' -o ',io];

% jun1208, thu
% sparky header is too complicated, so don't try assemble sparky format
% from scratch. 
% just output bianry floating matrix and use matrix2ucsf.

% this is not needed becuse matlab output column wise and this is
% consistent to the sparky requriement as higher axis (F2) data should
% change fastest.
% temp=mat.';

temp=real(mat);
temp=flipud(temp);
temp=fliplr(temp);

% humm. this gives good-looking spectrum but slightly shifted peaks
% maybe one-point shifted. how to deal with this...
% out(1:512,1:64)=temp(513:1024,65:128);
% out(513:1024,1:64)=temp(1:512,65:128);
% out(1:512,65:128)=temp(513:1024,1:64);
% out(513:1024,65:128)=temp(1:512,1:64);

% this was worse.
% out(1:511,1:64)=temp(514:1024,65:128);
% out(512:1024,1:64)=temp(1:513,65:128);
% out(1:511,65:128)=temp(514:1024,1:64);
% out(512:1024,65:128)=temp(1:513,1:64);

% this looks almost exactly same ppm to pipe->ucsf spectrum.
% so, FT vector has 1.5 dw past freq center?? weird but true.
% out(1:513,1:65)=temp(512:1024,64:128);
% out(514:1024,1:65)=temp(1:511,64:128);
% out(1:513,66:128)=temp(512:1024,1:63);
% out(514:1024,66:128)=temp(1:511,1:63);

out(1:n2/2+1,1:n1/2+1)=temp(n2/2:n2,n1/2:n1);
out(n2/2+2:n2,1:n1/2+1)=temp(1:n2/2-1,n1/2:n1);
out(1:n2/2+1,n1/2+2:n1)=temp(n2/2:n2,1:n1/2-1);
out(n2/2+2:n2,n1/2+2:n1)=temp(1:n2/2-1,1:n1/2-1);


% if you open file with 'b' option for the machine format for
% big-endian, don't need to swap the byte order explicitely.

% temp=float32(temp);
% temp(512,55)
% temp=swapbytes(temp);
% temp(512,55)

% deftest;

% write binary file, ucsf format.
% general header
fid=fopen('test1.mat','w','b');
% fseek(fid,0,'bof');

fwrite(fid,out,'float32');
fclose(fid);
    disp('---> data output is done.')
    
% system('pwd')
% system('source /Users/yomatsuki/.cshrc')
% system('ucsfdata')
system(command);
    disp('---> conversion to ucsf format is done.')
    
% matrix2ucsf -n1 128 -n2 1024 -f1 59.882 -f2 590.967 -sw1 4000 -sw2 8012.8
% -o1 150.30 -o2 11.58 -a1 15N -a2 1H -o test1.ucsf test1.mat








% obsolate below--

% fwrite(fid,s,'uchar');
% % fwrite(fid,0,'int8');
% % fseek(fid,9,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% % fwrite(fid,0,'int8');
% 
% % fseek(fid,10,'bof');
% % % fwrite(fid,2,'integer*1');
% fwrite(fid,2,'uint8');
% 
% % fseek(fid,11,'bof');
% % % fwrite(fid,1,'integer*1');
% fwrite(fid,1,'uint8');
% 
% % fseek(fid,12,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% fwrite(fid,0,'uint8');
% 
% % fseek(fid,13,'bof');
% % % fwrite(fid,2,'integer*1');
% fwrite(fid,2,'uint8');
% 
% for m=14:179
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% fwrite(fid,0,'uint8');
% end
% 
% % //////////////////////////////////////////////////
% % header for F1 (indirect) =========================
% % //////////////////////////////////////////////////
% % fseek(fid,180,'bof');
% % % fwrite(fid,nuc1,'char');
% fwrite(fid,nuc1,'char');
% 
% for m=186:187
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% fwrite(fid,0,'int8');
% end
% 
% % fseek(fid,188,'bof');
% % % % fwrite(fid,nt1,'integer*4');
% % fwrite(fid,nt1,'uint32');
% fwrite(fid,nt1,'uint8');
% 
% for m=189:195
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% fwrite(fid,0,'int8');
% % ==============================zero fill===================
% end
% 
% % fseek(fid,196,'bof');
% % % fwrite(fid,ntil1,'integer*4');
% fwrite(fid,ntil1,'uint32');
% % fwrite(fid,ntil1,'int8');
% 
% % for m=197:199
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% % fwrite(fid,0,'int8');
% % end
% 
% % fseek(fid,200,'bof');
% % % fwrite(fid,freq1,'real*4');
% fwrite(fid,freq1,'float32');
% 
% % fseek(fid,204,'bof');
% % % fwrite(fid,sw1,'real*4');
% fwrite(fid,sw1,'float32');
% 
% % fseek(fid,208,'bof');
% % % fwrite(fid,ctrppm1,'real*4');
% fwrite(fid,ctrppm1,'float32');
% 
% for m=212:307
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% fwrite(fid,0,'int8');
% end
% 
% %//////////////////////////////////////
% % header for F2 =====================
% %//////////////////////////////////////
% % fseek(fid,308,'bof');
% % % fwrite(fid,nuc2,'char');
% fwrite(fid,nuc2,'char');
% 
% for m=314:315
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% fwrite(fid,0,'int8');
% end
% 
% % fseek(fid,316,'bof');
% % % fwrite(fid,nt2,'integer*4');
% fwrite(fid,nt2,'uint32');
% % fwrite(fid,nt2,'int8');
% 
% for m=320:323
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% fwrite(fid,0,'int8');
% end
% 
% % fseek(fid,324,'bof');
% % % fwrite(fid,ntil2,'integer*4');
% fwrite(fid,ntil2,'uint32');
% % fwrite(fid,ntil2,'int8');
% 
% % for m=325:327
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% % % ==============================zero fill===================
% % fwrite(fid,0,'int8');
% % end
% 
% % fseek(fid,328,'bof');
% % % fwrite(fid,freq2,'real*4');
% fwrite(fid,freq2,'float32');
% 
% % fseek(fid,332,'bof');
% % % fwrite(fid,sw2,'real*4');
% fwrite(fid,sw2,'float32');
% 
% % fseek(fid,336,'bof');
% % % fwrite(fid,ctrppm2,'real*4');
% fwrite(fid,ctrppm2,'float32');
% 
% for m=340:435
% % fseek(fid,m,'bof');
% % % fwrite(fid,0,'integer*1');
% fwrite(fid,0,'int8');
% end
% 
% % data body
% % fseek(fid,436,'bof');
% fwrite(fid,A11,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A12,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A13,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A14,'float32');
% fwrite(fid,A15,'float32');
% fwrite(fid,A16,'float32');
% fwrite(fid,A17,'float32');
% fwrite(fid,A18,'float32');
% 
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A21,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A22,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A23,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A24,'float32');
% fwrite(fid,A25,'float32');
% fwrite(fid,A26,'float32');
% fwrite(fid,A27,'float32');
% fwrite(fid,A28,'float32');
% 
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A31,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A32,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A33,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A34,'float32');
% fwrite(fid,A35,'float32');
% fwrite(fid,A36,'float32');
% fwrite(fid,A37,'float32');
% fwrite(fid,A38,'float32');
% 
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A41,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A42,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A43,'float32');
% 
% % fseek(fid,0,'eof');
% fwrite(fid,A44,'float32');
% fwrite(fid,A45,'float32');
% fwrite(fid,A46,'float32');
% fwrite(fid,A47,'float32');
% fwrite(fid,A48,'float32');