function out=mplp2dslcv2(imat,sw1,sw2,ppm1,ppm2,f1,f2,dim,row)
% *** take row slice from 2D matrix with ppm axis ***
% Y. Matsuki, February, 2008
% usage:
% mplp2dslc(imat,sw1,sw2,ppm1,ppm2,f1,f2,dim,getppm,delppm)
% =====================================
% v=number of contours or [contour lines vector]
% specify sw1=spectral width in Hz for vertical axis
% specify sw2=spectral width in Hz for horizontal axis
% specify ppm at the center of axis
% specify f spectrometer freq in MHz
% dim: 1=horizontal slice, 2=vertical slice
% getppm: ppm+-delppm to take slice

% sept3009, output of the slice is introduced.

% mtk, dec1614, row is determined deterministically and given as an
% arguement

nr=length(imat(:,1));
nc=length(imat(1,:));

% FFT algorithm gives FTed data
% [0 -> most positive - one pts,most negative -> 0 - one pts]
xm1=-sw1/2:sw1/nr:-sw1/nr;
xp1=0:sw1/nr:(sw1/2)-(sw1/nr);
xmp1=[xp1 xm1];
xmp1p=(xmp1/f1)+ppm1;

% xm2=0:-(sw2/2)/((nc/2)-1):-sw2/2;
% xp2=sw2/2:-(sw2/2)/((nc/2)-1):0;
% xmp2=[xm2 xp2];
% xmp2p=-(xmp2/f2)+ppm2;
xm2=-sw2/2:sw2/nc:-sw2/nc;
xp2=0:sw2/nc:(sw2/2)-(sw2/nc);
xmp2=[xp2 xm2];
xmp2p=(xmp2/f2)+ppm2;

% % in comparison to scale in nmrPipe,
% % no need to shift matrix
% % imats=circshift(imat,[-1,-1]);
% contour(xmp2p,xmp1p,imat,v)
% set(gca,'XDir','reverse')
% set(gca,'YDir','reverse')

if dim==1
% for row=1:nr
%     if ((xmp1p(row)>=getppm-delppm) && (xmp1p(row)<=getppm+delppm))
        plot(xmp2p,imat(row,:))
        set(gca,'XDir','reverse')
        disp('row=');
        disp(row);
%         out=imat(row,:);
        out=row;
%     end
% end
elseif dim==2
% for clm=1:nc
%     if ((xmp2p(clm)>=(getppm-delppm)) && (xmp2p(clm)<=(getppm+delppm)))
        plot(xmp1p,imat(:,row))
        set(gca,'XDir','reverse')
        disp('row=');
        disp(row);
%         out=imat(:,clm);
        out=row;
%     end
% end
else
    disp('ERROR');
end



