function [omat1,omat2,tochk1,tochk2]=proc2d(c1cs2,s1cs2,...
    nzf1,nzf2,sw1,sw2,ph1,ph2,wndon1,wndon2,wndend1)
% *** 2D processing (=siftv2) ***
% Y. Matsuki, February, 2008
% usage:
% [omat1,omat2]=proc2d(c1cs2,s1cs2,...
%    nzf1,sw1,sw2,ph1,ph2,wndon,wndend1)
% ========================================================
% sw1: spectral width of NMR 1st dim
% ph1: phase [p0 p1] for NMR 1st dim
% wndend: 0-1, point window function dies down to zero. 1.0=tail before zfill.
% nzf1: number of in-direct dim points after zero-filling.
% only if wndon =1, sineb applies.
% jun1810, wndon1 and 2 introduced.

tic
    if wndon2==1
    temp1=sineb(c1cs2,90,wndend1,1);
    temp2=sineb(s1cs2,90,wndend1,1);
    disp('wind2, done.')
    else
        temp1=c1cs2;
        temp2=s1cs2;
    end

    tic
%     temp1=fft(temp1,[],1);
%     temp2=fft(temp2,[],1);
% nzf2 added, mtk, feb2610
    temp1=fft(temp1,nzf2,1);
    temp2=fft(temp2,nzf2,1);
    toc
    disp('FT2, done.')

    temp1=mphasec(temp1,sw2,ph2,1);
    temp2=mphasec(temp2,sw2,ph2,1);
    disp('phase2, done.')

tochk1=temp1;
tochk2=temp2;

    [temp1,temp2]=rrcplx(temp1,temp2);
    disp('swap for FT1, done.')

% tochk=temp1;

    if wndon1==1
    temp1=sineb(temp1,90,wndend1,2);
    temp2=sineb(temp2,90,wndend1,2);
    disp('wind1, done.')
    end

%    tochk=temp1;

    tic
    temp1=fft(temp1,nzf1,2);
    temp2=fft(temp2,nzf1,2);
    toc
    disp('FT1, done.')

    omat1=mphasec(temp1,sw1,ph1,2);
    omat2=mphasec(temp2,sw1,ph1,2);
    disp('phase1, done.')

%      tochk=omat1;

disp('All, done.')
toc