function [omatc,omats,mat]=read2dnl(nt1,nt2,inname,tab)
% *** .bruker 2D matrix (output from RNMR) read *** 
% ym, Dec1514, copy of brukread2dnl.m. reading pipe format, not Bruker
% format. so renamed.
% Y. Matsuki, October, 2011, reviewed.
% Y. Matsuki, January, 2009
% Y. Matsuki, August, 2009
% usage:
% [omatc,omats]=read2d(nt1nus,nt1,nt2,inname,tab)
% ========================================================
% see also binread.m for Sparky spectrum input.
% modified binread2d.m
% .bruker file is in int32 format.

% modified SIFT/Cowburn/minimumset/brukread2d.m, ym, may3013
% to read and deal Bruker NUS data before zeros reinstated.

% used in:
% macPro/SIFT/oct0311.m, reading nmrpipe's .fid file.
% Bruker ser file in /sparse.../jun1711SIFT_MHC/1.ser successful.
% #t2 points should be calculated by (file size-2048)/4/4/#t1.

% modified on oct0311,
% to read .fid file of nmrPipe binary
% Bruker data needs phase unwinding, so reading pipe format is better.

% mtk, dec1614, nt1nus is obsolete. use the number of entries in tab
% instead.

% fname=[inname '.binary'];
% fname='gb1nhsqc_006.binary';
% fname
inname
fid=fopen(inname,'r','l');
% fid=fopen(inname,'r','b');
% disp('check!')
%  fid=fopen(inname,'r','b');

% fseek(fid,0,'bof');
fseek(fid,2048,'bof');

nt1nus=size(tab,1);
mat=zeros(nt2*2,nt1nus*2);

for m=1:nt1nus*2
    temp=fread(fid,nt2*2,'*float32');
%     temp=fread(fid,nt2*2,'*int32');
    mat(:,m)=temp;
end

omatc=zeros(nt2,nt1);
omats=zeros(nt2,nt1);

l=1;
for n=1:2:nt1nus*2
    k=1;
    for m=1:2:nt2*2
%         omatc(k,l)=complex(mat(m,n),mat(m+1,n));
%         k=k+1;
        omatc(:,tab(l))=complex(mat(1:nt2,n),mat(nt2+1:2*nt2,n));
    end

    k=1;
    for m=1:2:nt2*2
%         omats(k,l)=complex(mat(m,n+1),mat(m+1,n+1));
%         k=k+1;
        omats(:,tab(l))=complex(mat(1:nt2,n+1),mat(nt2+1:2*nt2,n+1));
    end
    l=l+1;
    n
end

fclose(fid);
