function omat=sineb(imat,shft,trun,dim)
% *** Column-wise matrix windowing by shifted sine square ***
% Y. Matsuki, December, 2007
% usage:
% omat=sineb(imat,shft,trun,dim)
% ========================================================
% shft: 90deg=cosine square
% trun: 0-1, 1.0=end of data BEFORE zfill.
% so, normally set it to 1.0. when need of stronger wind, use < 1.0
% dim: MATLAB dimension to window.

% tic
nf1=length(imat(1,:));
nf2=length(imat(:,1));
wnd=zeros(nf2,nf1);

initr=(shft*pi)/180;

if dim==1
    incr=(pi-initr)/((nf2*trun)-1);
    for n=0:(nf2*trun)-1
        arg=initr+(n*incr);

% jun1908, mtk
% nmrPipe uses sine as default, rather than sine-square.
        wnd(n+1,:)=sin(arg)^2; 
%         wnd(n+1,:)=sin(arg); 
    end
elseif dim==2
    incr=(pi-initr)/((nf1*trun)-1);
    for n=0:(nf1*trun)-1
        arg=initr+(n*incr);
% jun1908, mtk
% nmrPipe uses sine as default, rather than sine-square.
        wnd(:,n+1)=sin(arg)^2; 
%         wnd(:,n+1)=sin(arg); 
    end
else
    disp('ERROR');
end

omat=wnd.*imat;

% toc
