function [mat1,mat2,mat3,mat4]=acqmode(mat1,mat2,mat3,mat4,alt1,neg1,alt2,neg2)
% *** treat a dimention according to the acq mode ***
% Y. Matsuki, December, 2014
% usage:
% acqmode(mat1,mat2,mat3,mat4,alt1,neg1,alt2,neg2)
% =====================================

nt1=size(mat1,2);
nt2=size(mat1,3);
nt3=size(mat1,1);

% t3 is complex
[mat11,mat22]=rrcplx(mat1,mat2);
[mat33,mat44]=rrcplx(mat3,mat4);
% t1 is complex now

% sign alternation
if alt1
    p=1;
    signalt=zeros(nt3,nt1,nt2);
    for n=1:2:nt1*2
        signalt(:,p,:)=sin(n*(pi/2));
        p=p+1;
    end
    mat11=mat11.*signalt;
    mat22=mat22.*signalt;
    mat33=mat33.*signalt;
    mat44=mat44.*signalt;
end

% imaginary negation
if neg1
    p=1;
    signalt=zeros(nt3,nt1,nt2);
    for n=1:nt1
        signalt(:,p,:)=-1;
        p=p+1;
    end
    mat11=complex(real(mat11),imag(mat11).*signalt);
    mat22=complex(real(mat22),imag(mat22).*signalt);
    mat33=complex(real(mat33),imag(mat33).*signalt);
    mat44=complex(real(mat44),imag(mat44).*signalt);
end





        [mat111,mat222]=rrcplx(mat11,mat33);
        [mat333,mat444]=rrcplx(mat22,mat44);        
% t2 is complex now

% sign alternation
if alt2
    p=1;
    signalt=zeros(nt3,nt1,nt2);
    for n=1:2:nt2*2
        signalt(:,:,p)=sin(n*(pi/2));
        p=p+1;
    end
    mat111=mat111.*signalt;
    mat222=mat222.*signalt;
    mat333=mat333.*signalt;
    mat444=mat444.*signalt;
end

% imaginary negation
if neg2
    p=1;
    signalt=zeros(nt3,nt1,nt2);
    for n=1:nt2
        signalt(:,p,:)=-1;
        p=p+1;
    end
    mat111=complex(real(mat111),imag(mat111).*signalt);
    mat222=complex(real(mat222),imag(mat222).*signalt);
    mat333=complex(real(mat333),imag(mat333).*signalt);
    mat444=complex(real(mat444),imag(mat444).*signalt);
end

        
        
        [mat11,mat33]=rrcplx(mat111,mat222);
        [mat22,mat44]=rrcplx(mat333,mat444);        
% t1 is complex now
        [mat1,mat2]=rrcplx(mat11,mat22);
        [mat3,mat4]=rrcplx(mat33,mat44);        
% t3 is complex now

        
        
        