function binout3dfreq(mat,n1,n2,n3,f1,f2,f3,sw1,sw2,sw3,o1,o2,o3,...
    a1,a2,a3,outname,pathin)
% *** binary output 3D spectrum to sparky format *** 
% Y. Matsuki, Sept, 2008
% Y. Matsuki, May, 2012
% usage:
% binout3d(mat,n1,n2,n3,f1,f2,f3,sw1,sw2,sw3,o1,o2,o3,...
%    a1,a2,a3,outname)
% ========================================================
path=pathin;
arg1=[' -n1 ',num2str(n1),' -n2 ',num2str(n2),' -n3 ',num2str(n3)];
arg2=[' -f1 ',num2str(f1),' -f2 ',num2str(f2),' -f3 ',num2str(f3)];
arg3=[' -sw1 ',num2str(sw1),' -sw2 ',num2str(sw2),' -sw3 ',num2str(sw3)];
arg4=[' -o1 ',num2str(o1),' -o2 ',num2str(o2),' -o3 ',num2str(o3)];
arg5=[' -a1 ',a1,' -a2 ',a2,' -a3 ',a3];
io=[outname '.ucsf ' 'temp3d.mat'];
command=[path,arg1,arg2,arg3,arg4,arg5,' -o ',io];

% 
% udlr3d=zeros(512,64,160);
udlr3d=zeros(n3,n2,n1);

temp=real(mat);

for n=1:n1
ud=flipud(temp(:,:,n));
udlr=fliplr(ud);
udlr3d(:,:,n1+1-n)=udlr;
end

out(n3/2+2:n3,n2/2+2:n2,n1/2+2:n1)=udlr3d(1:n3/2-1,1:n2/2-1,1:n1/2-1);
out(1:n3/2+1,n2/2+2:n2,n1/2+2:n1)=udlr3d(n3/2:n3,  1:n2/2-1,1:n1/2-1);
out(n3/2+2:n3,1:n2/2+1,n1/2+2:n1)=udlr3d(1:n3/2-1,  n2/2:n2,1:n1/2-1);
out(1:n3/2+1,1:n2/2+1,n1/2+2:n1)=udlr3d(n3/2:n3,    n2/2:n2,1:n1/2-1);

out(n3/2+2:n3,n2/2+2:n2,1:n1/2+1)=udlr3d(1:n3/2-1 ,1:n2/2-1,n1/2:n1);
out(1:n3/2+1,n2/2+2:n2,1:n1/2+1)=udlr3d(n3/2:n3   ,1:n2/2-1,n1/2:n1);
out(n3/2+2:n3,1:n2/2+1,1:n1/2+1)=udlr3d(1:n3/2-1  ,n2/2:n2 ,n1/2:n1);
out(1:n3/2+1,1:n2/2+1,1:n1/2+1)=udlr3d(n3/2:n3    ,n2/2:n2 ,n1/2:n1);


% write binary file, ucsf format.
% general header
fid=fopen('temp3d.mat','w','b');
% fseek(fid,0,'bof');

fwrite(fid,out,'float32');
fclose(fid);
    disp('---> data output is done.')
    
    command
system(command);
    disp('---> conversion to ucsf format is done.')

    
    
    
    
    