function brukout3dtimev1(incc,insc,incs,inss,nt1,nt2,nt3,outname)
% *** output 3D time data to .bruker format (spit from RNMR) ***
% Y. Matsuki, January, 2009
% Y. Matsuki, August, 2009
% Y. Matsuki, May, 2012
% usage:
% brukout3dtimev1(incc,insc,incs,inss,nt1,nt2,nt3,outname)
% ========================================================

out=zeros(nt3*2,nt1*nt2*4);
l=1;
for p=1:nt2
    for n=1:nt1
        k=1;
        for m=1:nt3
            out(k,l)=real(incc(m,n,p));
            k=k+1;
            out(k,l)=imag(incc(m,n,p));
            k=k+1;
        end
        l=l+1;
        
        k=1;
        for m=1:nt3
            out(k,l)=real(insc(m,n,p));
            k=k+1;
            out(k,l)=imag(insc(m,n,p));
            k=k+1;
        end
        l=l+1;
    end
    
    for n=1:nt1
        k=1;
        for m=1:nt3
            out(k,l)=real(incs(m,n,p));
            k=k+1;
            out(k,l)=imag(incs(m,n,p));
            k=k+1;
        end
        l=l+1;
        
        k=1;
        for m=1:nt3
            out(k,l)=real(inss(m,n,p));
            k=k+1;
            out(k,l)=imag(inss(m,n,p));
            k=k+1;
        end
        l=l+1;
    end
    p
end

fid=fopen(outname,'wb');
fseek(fid,0,'bof');
fwrite(fid,out,'integer*4');
fclose(fid);
disp('---> time data output is done.')





