function omat=mphase3dv3(in,sw,ph,dim)
% *** Column-wise matrix phasing ***
% Y. Matsuki, February, 2009
% Y. Matsuki, May, 2012
% usage:
% omat=mphase3dv3(in,sw,ph,dim)
% ========================================================
tic
nt3=length(in(:,1,1));
nt1=length(in(1,:,1));
nt2=length(in(1,1,:));

omat=in;
clear in

if (dim==1)
    phasem=zeros(nt3,nt1);
    nt=nt3;
%     xm=0:-(sw/2)/((nt/2)-1):-sw/2;
%     xp=sw/2:-(sw/2)/((nt/2)-1):0;
    pivt=1;
    d=sw/(nt-1);
    xp=d*((nt/2)-pivt):-1*d:d*(1-pivt);
    xm=d*(nt-pivt):-1*d:d*((nt/2)+1-pivt);

    xmp=[xp xm];

    for p=1:nt
        arg=ph(1)*pi/180 + ((ph(2)*pi/180) / sw ) *xmp(p);
        phasem(p,:)=cos(arg)+1i*sin(arg);
    end

    for q=1:nt2
        omat(:,:,q)=phasem.*omat(:,:,q);
    end

elseif (dim==2)
    phasem=zeros(nt1,nt2);
    nt=nt1;
%     xm=0:-(sw/2)/((nt/2)-1):-sw/2;
%     xp=sw/2:-(sw/2)/((nt/2)-1):0;
    pivt=1;
    d=sw/(nt-1);
    xp=d*((nt/2)-pivt):-1*d:d*(1-pivt);
    xm=d*(nt-pivt):-1*d:d*((nt/2)+1-pivt);

    xmp=[xp xm];

    for p=1:nt
        arg=ph(1)*pi/180 + ((ph(2)*pi/180) / sw ) *xmp(p);
        phasem(p,:)=cos(arg)+1i*sin(arg);
    end

    for q=1:nt3
        omat(q,:,:)=phasem.*squeeze(omat(q,:,:));
    end
    
%    omat=permute(pomat,[2 1 3]);
elseif (dim==3)
    phasem=zeros(nt1,nt2);
    nt=nt2;
%     xm=0:-(sw/2)/((nt/2)-1):-sw/2;
%     xp=sw/2:-(sw/2)/((nt/2)-1):0;
    pivt=1;
    d=sw/(nt-1);
    xp=d*((nt/2)-pivt):-1*d:d*(1-pivt);
    xm=d*(nt-pivt):-1*d:d*((nt/2)+1-pivt);

    xmp=[xp xm];

    for p=1:nt
        arg=ph(1)*pi/180 + ((ph(2)*pi/180) / sw ) *xmp(p);
        phasem(:,p)=cos(arg)+1i*sin(arg);
    end
    for q=1:nt3
        omat(q,:,:)=phasem.*squeeze(omat(q,:,:));
    end
    
else
    disp('ERROR');
end


toc
