function [out]=ppm2pts(in,sw,np,cent,freq,dir)
% *** convert ppm reading to point unit ***
% Y. Matsuki, March, 2009
% Y. Matsuki, May, 2012
% usage:
% [out]=ppm2pts(in,sw,np,cent,freq,dir)
% =====================================
% sw: in Hz
% np: no of points
% cent: in ppm
% freq: in MHz
% dir: 1 for vertical axis, 2 for horizontal axis

% see scrabble note, feb1109, thu
del=sw/(np-1);
delp=del/freq;
% FFT algorithm gives FTed data
% [0 -> most positive - half delta;most negative - half delta -> a half delta]
xp=     0       :del: sw/2-del/2;
xm=-sw/2-del/2 :del: -1*del;
% this gave perfect agreement to Sparky.

xmp=[xp xm];
xmpp=(xmp/freq)+cent;

nele=length(in);
if nele==0
    [x,y]=ginput;
    
    if dir==1
        in=y.';
    elseif dir==2
        in=x.';
    else
        disp('ERROR,dir must be 1 or 2');
    end
    nele=length(in);
end

out=zeros(1,nele);
for p=1:nele
for q=1:np-1
    if ((in(p)>=xmpp(q)) && (in(p)<xmpp(q+1)))
        if abs(xmpp(q+1)-in(p)) < abs(delp/2)
            out(1,p)=q+1;
        else
            out(1,p)=q;
        end
    elseif in(p)>=xmpp(np) && in(p)<=cent
        if abs(in(p)-xmpp(np)) < abs(delp/2)
            out(1,p)=np;
        else
            out(1,p)=1;
        end
    elseif in(p)>=xmpp(np/2)
        disp('ERROR,ppm too big');
    elseif in(p)<=xmpp(np/2+1)
        disp('ERROR,ppm too small');        
    end
end
end
