function [AA,t1F3t2_1,t2F1F3]=proc3dv2(c1c2,s1c2,c1s2,s1s2,...
    nzf1,nzf2,nzf3,sw1,sw2,sw3,ph1,ph2,ph3,wndon1,wndon2,wndon3,...
    wndend1,wndend2,wndend3)
% *** 3D processing *** 
% Y. Matsuki, September, 2008
% Y. Matsuki, May, 2012
% usage:
%[AA,DA,AD,DD]=proc3dv2(c1c2,s1c2,c1s2,s1s2,...
%    nzf1,nzf2,nzf3,sw1,sw2,sw3,ph1,ph2,ph3,on,wndend1,wndend2)
% ========================================================

tic


    if wndon3==1
    temp1=sineb3dv2(c1c2,90,wndend3,1);
%     temp1=sineb3d(c1c2,90,wndend3,1);
    clear c1c2
    temp2=sineb3dv2(s1c2,90,wndend3,1);
%     temp2=sineb3d(s1c2,90,wndend3,1);
    clear s1c2
    temp3=sineb3dv2(c1s2,90,wndend3,1);
%     temp3=sineb3d(c1s2,90,wndend3,1);
    clear c1s2
    temp4=sineb3dv2(s1s2,90,wndend3,1);
%     temp4=sineb3d(s1s2,90,wndend3,1);
    clear s1s2

    disp('wind3 done')
    else
        temp1=c1c2;
        temp2=s1c2;
        temp3=c1s2;
        temp4=s1s2;
    end

    tic
    temp1=fft(temp1,nzf3,1);
    temp2=fft(temp2,nzf3,1);
    temp3=fft(temp3,nzf3,1);
    temp4=fft(temp4,nzf3,1);
    toc
    disp('FT3 done')
% 0.55sec

    temp1=mphase3dv3(temp1,sw3,ph3,1);
    temp2=mphase3dv3(temp2,sw3,ph3,1);
    temp3=mphase3dv3(temp3,sw3,ph3,1);
    temp4=mphase3dv3(temp4,sw3,ph3,1);
    disp('phase3 done')
% 0.33sec x 4
    
             [temp1]=rrcplx3dv3(temp1,temp2);
             [temp3]=rrcplx3dv3(temp3,temp4);
    disp('swap3 done')
% 1.9sec


t1F3t2_1=temp1;
t1F3t2_3=temp3;

%%
    if wndon1==1
    temp1=sineb3dv2(temp1,90,wndend1,2);
%     temp2=sineb3d(temp2,90,wndend1,2);
    temp3=sineb3dv2(temp3,90,wndend1,2);
%     temp4=sineb3d(temp4,90,wndend1,2);
    disp('wind1 done')
    end

    tic
    temp1=fft(temp1,nzf1,2);
%     temp2=fft(temp2,nzf1,2);
    temp3=fft(temp3,nzf1,2);
%     temp4=fft(temp4,nzf1,2);
    toc
    disp('FT1 done')

    temp1=mphase3dv3(temp1,sw1,ph1,2);
    temp3=mphase3dv3(temp3,sw1,ph1,2);

    disp('phase1 done')
    [temp1]=rrcplx3dv2(temp1,temp3);
    [t2F1F3]=rrcplx3dv2(t1F3t2_1,t1F3t2_3); % may1612, mtk.
    
%     [temp3,temp4]=rrcplx3dv2(temp2,temp4);
    disp('swap1 done')
    % 17sec

    if wndon2==1
    temp1=sineb3dv2(temp1,90,wndend2,3);
%     temp2=sineb3d(temp2,90,wndend2,3);
%     temp3=sineb3d(temp3,90,wndend2,3);
%     temp4=sineb3d(temp4,90,wndend2,3);
    disp('wind2 done')
    end

    tic
    temp1=fft(temp1,nzf2,3);
%     temp2=fft(temp2,nzf2,3);
%     temp3=fft(temp3,nzf2,3);
%     temp4=fft(temp4,nzf2,3);
    toc
    disp('FT2 done')
% 70sec, 36sec
    
%     AA=mphase3dv2(temp1,sw2,ph2,3);
% compatible with nmrpipe.
    AA=mphase3dv3(temp1,sw2,ph2,3);

%     DA=mphase3d(temp2,sw2,ph2,3);
%     AD=mphase3d(temp3,sw2,ph2,3);
%     DD=mphase3d(temp4,sw2,ph2,3);
    disp('phase2 done')
    
toc
disp('All done')

