function [cc,sc,cs,ss]=read3dnl(nt1,nt2,nt3,header,inname,nustab)
% *** read nmrpipe format 3D NUS data ***
% Y. Matsuki, December, 2014
%   brukread3dv2.m is modified to read 3d nus data (before zero insertion).

% usage:
% [cc,sc,cs,ss]=read3dnl(nt1,nt2,nt3,header,inname,nustab)
% ========================================================

% fname=[inname '.binary'];
inname
fid=fopen(inname,'r','l');
% fid=fopen(inname,'r','b');

fseek(fid,header,'bof');
% fseek(fid,2048,'bof');

% mat=zeros(nt3*2,size(nustab,1)*4);
% for p=1:size(nustab,1)*4
%     mat(:,p)=fread(fid,nt3*2,'*float32');
% end
% 
% cc=zeros(nt3,nt1,nt2);
% sc=zeros(nt3,nt1,nt2);
% cs=zeros(nt3,nt1,nt2);
% ss=zeros(nt3,nt1,nt2);
% p=1;
% for n=1:4:size(nustab,1)*4
%     cc(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n)  ,mat(nt3+1:2*nt3,n));
%     sc(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n+1),mat(nt3+1:2*nt3,n+1));
%     cs(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n+2),mat(nt3+1:2*nt3,n+2));
%     ss(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n+3),mat(nt3+1:2*nt3,n+3));
%     p=p+1;
% end
% 
% fclose(fid);

cc=zeros(nt3,nt1,nt2);
sc=zeros(nt3,nt1,nt2);
cs=zeros(nt3,nt1,nt2);
ss=zeros(nt3,nt1,nt2);

nt2=size(nustab,1); %360
nt1=1;

for p=1:nt2
    
    mat=zeros(nt3*2,nt1*2);
    for m=1:nt1*2
        temp=fread(fid,nt3*2,'*float32');
        %     temp=fread(fid,nt2*2,'*int32');
        mat(:,m)=temp;
    end
    
    for n=1:2:nt1*2
        cc(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n),mat(nt3+1:2*nt3,n));
        sc(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n+1),mat(nt3+1:2*nt3,n+1));
    end
    
    
    
    mat=zeros(nt3*2,nt1*2);
    for m=1:nt1*2
        temp=fread(fid,nt3*2,'*float32');
        %     temp=fread(fid,nt2*2,'*int32');
        mat(:,m)=temp;
    end
    
    for n=1:2:nt1*2
        cs(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n),mat(nt3+1:2*nt3,n));
        ss(:,nustab(p,1),nustab(p,2))=complex(mat(1:nt3,n+1),mat(nt3+1:2*nt3,n+1));
    end
    
p    
end


fclose(fid);

