function [temp1,temp2,temp3,temp4,chk]=sift3dv10(c1c2,s1c2,c1s2,s1s2,...
    ncyca,timetab,sigf1,sigf2,sigf3,nzf1,nzf2,nzf3,ofst,pick,sw1,sw2)
% *** 3D SIFT, memory optimized *** 
% Y. Matsuki, March, 2010
% Y. Matsuki, December, 2011
% Y. Matsuki, May, 2012
% usage:
% [temp1,temp2,temp3,temp4,chk]=sift3dv10(c1c2,s1c2,c1s2,s1s2,...
%     ncyca,timetab,sigf1,sigf2,sigf3,nzf1,nzf2,nzf3,ofst,pick,sw1,sw2)
% ========================================================
tic
    orgn1=length(c1c2(1,:,1));
    orgn2=length(c1c2(1,1,:));
    orgn3=length(c1c2(:,1,1));

    wndend3=1.0;
    temp1=sineb3d(c1c2,90,wndend3,1);
    temp2=sineb3d(s1c2,90,wndend3,1);
    temp3=sineb3d(c1s2,90,wndend3,1);
    temp4=sineb3d(s1s2,90,wndend3,1);
%     disp('wind3 done')
    
    tic
    temp1=fft(temp1,nzf3,1);
    temp2=fft(temp2,nzf3,1);
    temp3=fft(temp3,nzf3,1);
    temp4=fft(temp4,nzf3,1);
%     temp1=fft(c1c2,nzf3,1);
%     temp2=fft(s1c2,nzf3,1);
%     temp3=fft(c1s2,nzf3,1);
%     temp4=fft(s1s2,nzf3,1);
%     toc
%     disp('FT3 done')
    
    % oct0608
    clear c1c2
    clear s1c2
    clear c1s2
    clear s1s2
    

    nr=length(sigf3(:,1));
    ntot=0;
    for n=1:nr
        nele(n)=sigf3(n,2)-sigf3(n,1)+1;
        ntot=ntot+nele(n);        
    end
    
    p=1;
    cycm1=zeros(ntot,orgn1,orgn2);
    cycm2=zeros(ntot,orgn1,orgn2);
    cycm3=zeros(ntot,orgn1,orgn2);
    cycm4=zeros(ntot,orgn1,orgn2);
    for m=1:nr
        cycm1(p:p+nele(m)-1,:,:)=temp1(sigf3(m,1):sigf3(m,2),:,:);
        cycm2(p:p+nele(m)-1,:,:)=temp2(sigf3(m,1):sigf3(m,2),:,:);
        cycm3(p:p+nele(m)-1,:,:)=temp3(sigf3(m,1):sigf3(m,2),:,:);
        cycm4(p:p+nele(m)-1,:,:)=temp4(sigf3(m,1):sigf3(m,2),:,:);
        p=p+nele(m);
    end

    clear temp1
    clear temp2
    clear temp3
    clear temp4
    
    temp1=cycm1;
    temp2=cycm2;
    temp3=cycm3;
    temp4=cycm4;

% s/n calc. oct1708, mtk
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++
npts=500;
    brand=zeros(npts,2);
nele1=0;
nele2=0;
nele3=0;
nr1=length(sigf1(:,1));
nr2=length(sigf2(:,1));
nr3=length(sigf3(:,1));
for q=1:nr1
    nele1=nele1+(sigf1(q,2)-sigf1(q,1)+1);
end
for q=1:nr2
    nele2=nele2+(sigf2(q,2)-sigf2(q,1)+1);
end
for q=1:nr3
    nele3=nele3+(sigf3(q,2)-sigf3(q,1)+1);
end



    for p=1:npts
        brand(p,:)=round(rand(1,2).*[nzf1*length(pick),nzf2]); % may1712, mtk.
        if brand(p,1)==0
            brand(p,1)=1;
        end
        if brand(p,2)==0
            brand(p,2)=1;
        end
    end
%     cyci=1;
chk=zeros(ncyca,3);
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    disp('cyca =')
for cyca=1:ncyca
    % s/n calc. oct1708, mtk
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++

brtarea=proc3dintv3(cycm1,cycm2,cycm3,cycm4,sw1,sw2,nzf1,nzf2,1.0,1.0);

% ooooooooooooooooooooooooooooooooooooooooooooo
% look up "pick" on the fly. mtk, dec1314, sat.
if isempty(pick)
    [a,b]=max(max(max(real(brtarea),[],3),[],2));
%     [c,d]=max(a);
% 	pick=b(d)
	pick=b;
end
    
% ooooooooooooooooooooooooooooooooooooooooooooo

[noisbrt,mx]=absmedianv9(brtarea,brand,pick);


sn=mx/noisbrt;
chk(cyca,:)=[mx noisbrt sn];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%     disp('cyca =')
    disp(cyca)
    % 1f.
    % c1c2(A3,D3)
    % s1c2(A3,D3)
    % c1s2(A3,D3)
    % s1s2(A3,D3)
    
% sept2509, better like this for memory use???
%     [A]=rrcplx3dv3(cycm1,cycm2);
	A=complex(real(cycm1),real(cycm2));

%     [cycm2]=rrcplx3dv3i(cycm1,cycm2);
	cycm2=complex(imag(cycm1),imag(cycm2));

    cycm1=A;
%     [A]=rrcplx3dv3(cycm3,cycm4);
	A=complex(real(cycm3),real(cycm4));
    
%     [cycm4]=rrcplx3dv3i(cycm3,cycm4);
	cycm4=complex(imag(cycm3),imag(cycm4));

    cycm3=A;
    clear A
%     disp('swap for FT1 done')
    % 2.
    % (c1,s1)c2A3
    % (c1,s1)c2D3
    % (c1,s1)s2A3
    % (c1,s1)s2D3

%     for cyc1=1:ncyc1
%         tic
        cycm1=fft(cycm1,nzf1,2);
        cycm2=fft(cycm2,nzf1,2);
        cycm3=fft(cycm3,nzf1,2);
        cycm4=fft(cycm4,nzf1,2);
%         toc
%         disp('FT1 done')
        % 2f.
        % (A1,D1)c2A3
        % (A1,D1)c2D3
        % (A1,D1)s2A3
        % (A1,D1)s2D3

%             [A]=rrcplx3dv3(cycm1,cycm3);
          	A=complex(real(cycm1),real(cycm3));
%             [B]=rrcplx3dv3i(cycm1,cycm3);
        	B=complex(imag(cycm1),imag(cycm3));
            cycm1=A;
            clear A
%             [cycm3]=rrcplx3dv3(cycm2,cycm4);
          	cycm3=complex(real(cycm2),real(cycm4));
%             [cycm4]=rrcplx3dv3i(cycm2,cycm4);
        	cycm4=complex(imag(cycm2),imag(cycm4));
            cycm2=B;
            clear B
%             disp('swap for FT2 done')
            % 3.
            % A1(c2,s2)A3
            % D1(c2,s2)A3
            % A1(c2,s2)D3
            % D1(c2,s2)D3

%     for cyc2=1:ncyc2
%         tic
        cycm1=fft(cycm1,nzf2,3);
        cycm2=fft(cycm2,nzf2,3);
        cycm3=fft(cycm3,nzf2,3);
        cycm4=fft(cycm4,nzf2,3);
%         toc
%         disp('FT2 done')
            % 3f.
            % A1(A2,D2)A3
            % D1(A2,D2)A3
            % A1(A2,D2)D3
            % D1(A2,D2)D3

        cycm1=fzr3dv3(cycm1,sigf1,sigf2,ofst);
        cycm2=fzr3dv3(cycm2,sigf1,sigf2,ofst);
        cycm3=fzr3dv3(cycm3,sigf1,sigf2,ofst);
        cycm4=fzr3dv3(cycm4,sigf1,sigf2,ofst);
%         disp('fzr3d done')

%         tic
        cycm1=ifft(cycm1,[],3);
        cycm2=ifft(cycm2,[],3);
        cycm3=ifft(cycm3,[],3);
        cycm4=ifft(cycm4,[],3);
%         toc
%         disp('IFT2 done')
        
        cycm1=cycm1(:,:,1:orgn2);
        cycm2=cycm2(:,:,1:orgn2);
        cycm3=cycm3(:,:,1:orgn2);
        cycm4=cycm4(:,:,1:orgn2);
            % 3.
            % A1(c2,s2)A3
            % D1(c2,s2)A3
            % A1(c2,s2)D3
            % D1(c2,s2)D3
            
%              [A]=rrcplx3dv3(cycm1,cycm2);
             A=complex(real(cycm1),real(cycm2));

%              [B]=rrcplx3dv3i(cycm1,cycm2);
             B=complex(imag(cycm1),imag(cycm2));
             cycm1=A;
             clear A
%              [cycm2]=rrcplx3dv3(cycm3,cycm4);
           	cycm2=complex(real(cycm3),real(cycm4));
%              [cycm4]=rrcplx3dv3i(cycm3,cycm4);
          	cycm4=complex(imag(cycm3),imag(cycm4));
             cycm3=B;
             clear B
%              disp('swap for FT1 done')
            % 2f.
            % (A1,D1)c2A3
            % (A1,D1)c2D3
            % (A1,D1)s2A3
            % (A1,D1)s2D3

%         tic
        cycm1=ifft(cycm1,[],2);
        cycm2=ifft(cycm2,[],2);
        cycm3=ifft(cycm3,[],2);
        cycm4=ifft(cycm4,[],2);
%         toc
%         disp('IFT1 done')

        cycm1=cycm1(:,1:orgn1,:);
        cycm2=cycm2(:,1:orgn1,:);
        cycm3=cycm3(:,1:orgn1,:);
        cycm4=cycm4(:,1:orgn1,:);
        % 2.
        % (c1,s1)c2A3
        % (c1,s1)c2D3
        % (c1,s1)s2A3
        % (c1,s1)s2D3
     
% [A]=rrcplx3dv3(cycm1,cycm2);
A=complex(real(cycm1),real(cycm2));
% [cycm2]=rrcplx3dv3i(cycm1,cycm2);
cycm2=complex(imag(cycm1),imag(cycm2));
cycm1=A;
clear A
% [A]=rrcplx3dv3(cycm3,cycm4);
A=complex(real(cycm3),real(cycm4));
% [cycm4]=rrcplx3dv3i(cycm3,cycm4);
cycm4=complex(imag(cycm3),imag(cycm4));
cycm3=A;
clear A
% disp('swap for FT3 done')
% 1f.
% c1c2(A3,D3)
% s1c2(A3,D3)
% c1s2(A3,D3)
% s1s2(A3,D3)

        cycm1=rplc3d(temp1,cycm1,timetab);
        cycm2=rplc3d(temp2,cycm2,timetab);
        cycm3=rplc3d(temp3,cycm3,timetab);
        cycm4=rplc3d(temp4,cycm4,timetab);
%         disp('replace done')

end

temp1=zeros(nzf3,orgn1,orgn2);
temp2=zeros(nzf3,orgn1,orgn2);
temp3=zeros(nzf3,orgn1,orgn2);
temp4=zeros(nzf3,orgn1,orgn2);
p=1;
for n=1:nr
    temp1(sigf3(n,1):sigf3(n,2),:,:)=cycm1(p:p+nele(n)-1,:,:);
    temp2(sigf3(n,1):sigf3(n,2),:,:)=cycm2(p:p+nele(n)-1,:,:);
    temp3(sigf3(n,1):sigf3(n,2),:,:)=cycm3(p:p+nele(n)-1,:,:);
    temp4(sigf3(n,1):sigf3(n,2),:,:)=cycm4(p:p+nele(n)-1,:,:);
    p=p+nele(n);
end

clear cycm1
clear cycm2
clear cycm3
clear cycm4


% 1f.
% c1c2(A3,D3)
% s1c2(A3,D3)
% c1s2(A3,D3)
% s1s2(A3,D3)
% tic
temp1=ifft(temp1,[],1);
temp2=ifft(temp2,[],1);
temp3=ifft(temp3,[],1);
temp4=ifft(temp4,[],1);
% toc
% disp('IFT3 done')

temp1=temp1(1:orgn3,:,:);
temp2=temp2(1:orgn3,:,:);
temp3=temp3(1:orgn3,:,:);
temp4=temp4(1:orgn3,:,:);
% 1.
% c1c2(c3,s3)
% s1c2(c3,s3)
% c1s2(c3,s3)
% s1s2(c3,s3)
        
toc
disp('All done')

