function omat=sineb3d(imat,shft,trun,dim)
% *** Windowing 3D matrix by shifted sine square ***
% Y. Matsuki, February, 2008
% Y. Matsuki, May, 2012
% usage:
% omat=sineb3d(imat,shft,trun,dim)
% ========================================================

% tic
nf1=length(imat(1,:,1));
nf2=length(imat(1,1,:));
nf3=length(imat(:,1,1));
wnd=zeros(nf3,nf1,nf2);

initr=(shft*pi)/180;

if dim==2
    incr=(pi-initr)/((nf1*trun)-1);
    for n=0:nf1*trun-1
        if (n<nf1)
        arg=initr+(n*incr);
        wnd(:,n+1,:)=sin(arg)^2;
        end
    end
elseif dim==3
    incr=(pi-initr)/((nf2*trun)-1);
    for n=0:nf2*trun-1
        if (n<nf2)
        arg=initr+(n*incr);
        wnd(:,:,n+1)=sin(arg)^2;
        end
    end
elseif dim==1
    incr=(pi-initr)/((nf3*trun)-1);
    for n=0:nf3*trun-1
        if (n<nf3)
        arg=initr+(n*incr);
        wnd(n+1,:,:)=sin(arg)^2;
        end
    end
else
    disp('ERROR');
end

omat=wnd.*imat;

% toc
